#pragma warning( disable : 4996 ) // Allow non _s func's

// TEXTURE CONTEXT MANIPULATION

#ifndef TEXCONTEXT_H
#define TEXCONTEXT_H

#define TEXFX_CHROME	0x12FAC806

#include <Windows.h>
#include <stdio.h>
#include "dblreader.h"
#include "chunkdt.h"

typedef struct TexContext_t {
	char* associatedMesh; // ? Possibly the mesh file associated
	INT16 iTexNum; // Texture associated with this entry
	INT16 iOffset; // Offset to this entry in the chunkfile (have to add headersize)
	INT8 iPacked; // How many sub-entries this entry has packed inside of it
	INT iFX; // Effects of the texture, see TEXFX_ definitions
} TexContext_s;

typedef struct TexContextList_t {
	TexContext_s* context; // Pointer to contexts
	INT iEntries; // Number of entries as described by the context header
	INT iWrittenEntries; // Total number of entries, including individual sub-entries inside other entries
} TexContextList_s;

// Load a texture context chunk into memory
TexContextList_s* LoadTexContextChunk( const char* chunkfname );

// Create a texture context chunk from given data
BOOL CreateTexContextChunk( const char* chunkfname, TexContextList_s* pTexContextList, dbl_chunk_header_s* pHeader );

// Find a texture context chunk
char* FindATexContextChunk( char* szChunkfilename );

#endif